 

IF NOT OBJECT_ID('UFD_EST_PROD_FACE_FIN_ALCADA_SUG') IS NULL
	BEGIN 
		DROP FUNCTION UFD_EST_PROD_FACE_FIN_ALCADA_SUG
	END

GO

--SELECT * FROM UFD_EST_PROD_FACE_FIN_ALCADA_SUG(1,1,37888)
CREATE FUNCTION UFD_EST_PROD_FACE_FIN_ALCADA_SUG(@CD_EMP	INT,
												 @CD_FILIAL	INT,
												 @CD_PROD	INT)
RETURNS @RS_RESULT TABLE (	CD_EMP		INT,
							CD_PROD		INT,
							CD_FILIAL	INT,
							QT_SUG		MONEY)
AS							
	BEGIN 
		DECLARE @CD_ARV_MERC_CATEG INT
		DECLARE @DT_INI DATETIME
		DECLARE @DT_FIM DATETIME
		DECLARE @DT_ANO_MES_INI INT
		DECLARE @DT_ANO_MES_FIM INT
		DECLARE @QT_COB MONEY 

DECLARE @RS_TEMP TABLE (	CD_EMP		INT,
							CD_PROD		INT,
							CD_FILIAL	INT,
							QT_SUG		MONEY,
							TP_REG		INT)

		IF EXISTS (SELECT CD_EMP 
				   FROM EST_PROD_RC_CLI_CONV P 
				   WHERE CD_EMP = @CD_EMP 						
						AND CD_PROD = @CD_PROD				
						AND P.REPOSICAO   = 'S')
		   OR 
		   EXISTS (SELECT CD_EMP 
				   FROM EST_PROD_CPL_MEDIAP
				   WHERE FALTA_CRONICA = 1
						AND CD_EMP = @CD_EMP 
						AND CD_FILIAL = @CD_FILIAL 
						AND CD_PROD = @CD_PROD)
		   OR
		   EXISTS (SELECT CD_EMP 
				   FROM EST_PROD_CPL
				   WHERE CD_EMP = @CD_EMP 
						AND CD_FILIAL = @CD_FILIAL 
						AND CD_PROD = @CD_PROD
						AND VLR_CUSTO_MD > 150)
			
			BEGIN
				INSERT @RS_TEMP
					SELECT  @CD_EMP, 
							@CD_PROD, 
							@CD_FILIAL,
							0,
							0
				RETURN
			END						 
			
		SET @DT_INI = CONVERT(VARCHAR(10),DATEADD(MONTH,-12,GETDATE()), 101)
		SET @DT_FIM = CONVERT(VARCHAR(10),GETDATE(), 101)				

		SET @DT_ANO_MES_INI =  (SELECT CONVERT(VARCHAR(6), @DT_INI, 112))
		SET @DT_ANO_MES_FIM =  (SELECT CONVERT(VARCHAR(6), @DT_FIM, 112))

		SET @CD_ARV_MERC_CATEG = ISNULL((SELECT CD_ARV_MERC_CATEG
										FROM EST_PROD_EST_ARV_MERCADOLOGICA
										WHERE 
											CD_EMP = @CD_EMP
											AND CD_PROD = @CD_PROD),0)


		INSERT INTO @RS_TEMP
			SELECT	@CD_EMP, 
					@CD_PROD, 
					@CD_FILIAL,
					ROUND((C.MEDIAF / 30.000) * (CASE WHEN ISNULL(T.PARAM_LIMITE,0) = 0 THEN 45 ELSE ISNULL(T.PARAM_LIMITE,0) END),0) AS QT_SUG,
					0 TP_REG			
			FROM EST_PROD_CPL C
				OUTER APPLY UFD_EST_ALCADA_CP_COB_EST_PROD(C.CD_EMP,C.CD_PROD, C.CD_SIGLA, 1) T
			WHERE C.CD_EMP = @CD_EMP
				AND C.CD_FILIAL = @CD_FILIAL
				AND C.CD_PROD = @CD_PROD 
				
		INSERT INTO @RS_TEMP
			SELECT  I.CD_EMP, 
					I.CD_PROD, 
					@CD_FILIAL,
					MAX(I.QT_IT),
					1 TP_REG
			--FROM EST_PROD_CPL_ANALISE I				
			FROM PDV_VD_IT I				
				INNER JOIN PRC_FILIAL_CLUSTER_PRC_FILIAL C ON 
					I.CD_EMP = C.CD_EMP 
					AND I.CD_FILIAL = C.CD_FILIAL  					
			WHERE 
				--ANO_MES BETWEEN @DT_ANO_MES_INI AND @DT_ANO_MES_FIM					
				I.CD_EMP = @CD_EMP
				AND I.CD_PROD = @CD_PROD
				AND I.ST_IT = 1
				AND I.DT_VD BETWEEN @DT_INI AND @DT_FIM 
				AND C.CD_CLUSTER IN (SELECT T.CD_CLUSTER FROM PRC_FILIAL_CLUSTER_PRC_FILIAL T WHERE T.CD_EMP = @CD_EMP AND T.CD_FILIAL = @CD_FILIAL)
			GROUP BY 
				I.CD_EMP, 
				I.CD_PROD
				

		INSERT INTO @RS_TEMP
			SELECT  @CD_EMP, 
					@CD_PROD, 
					@CD_FILIAL,
					MAX(QT_IT) AS TOT,
					2 AS TP_REG				
			FROM PDV_VD_IT I				
			WHERE
				I.CD_EMP = @CD_EMP
				AND I.CD_FILIAL = @CD_FILIAL
				AND I.CD_PROD = @CD_PROD 
				AND I.ST_IT = 1
				AND I.DT_VD BETWEEN @DT_INI AND @DT_FIM 

		INSERT INTO @RS_RESULT
			SELECT 
					CD_EMP, 
					CD_PROD,
					CD_FILIAL,
					MAX  (QT_SUG) AS QT_SUG
			FROM @RS_TEMP 
			GROUP BY 
					CD_EMP, 
					CD_PROD,
					CD_FILIAL
				
		RETURN
							
	END


  